cd "C:\Data\Dropbox\Research\2012- Paradoxical Religiosity\Data\Replication Data\"
set more off

use "Merged Dataset.dta", clear


egen missexpertise = rowmiss(polknowledge polinterest polexposure)
egen missrfs = rowmiss(rfs1-rfs12)
egen missia = rowmiss(iasocial iaedu iacrime iatax)

egen expertise = rowmean(polknowledge polinterest polexposure)
replace expertise = . if missexpertise>1
egen rfs = rowmean(rfs1-rfs12)
replace rfs = . if missrfs>6
egen ia = rowmean(iasocial iaedu iacrime iatax)
replace ia = . if missia>2

*standardize independent variables*
egen zexpertise = std(expertise)
egen zrfs = std(rfs)
egen zia = std(ia)
egen zedu = std(edu)
egen zage = std(age)

*set output directory*
cd "C:\Data\Dropbox\Research\2012- Paradoxical Religiosity\Data\Replication Data\Results"

log using "Robustness 3 - Including Unbelievers Interactions.log"

/*================*/
/*2-way INTERACTIONS: FUNDAMENTALISM X TREATMENTS*/
/*================*/

reg voting zedu zage zexpertise zia trel##usa tblending##usa tseparate##usa trel##c.zrfs tblending##c.zrfs tseparate##c.zrfs
margins, at(zrfs=(-1 1) usa=0 trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=0 trel=0 tblending=1 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=0 trel=0 tblending=0 tseparate=1) atmean vsquish

reg attitude zedu zage zexpertise zia trel##usa tblending##usa tseparate##usa trel##c.zrfs tblending##c.zrfs tseparate##c.zrfs
margins, at(zrfs=(-1 1) usa=0 trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=0 trel=0 tblending=1 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=0 trel=0 tblending=0 tseparate=1) atmean vsquish

reg competence zedu zage zexpertise zia trel##usa tblending##usa tseparate##usa trel##c.zrfs tblending##c.zrfs tseparate##c.zrfs
margins, at(zrfs=(-1 1) usa=0 trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=0 trel=0 tblending=0 tseparate=1) atmean vsquish

reg integrity zedu zage zexpertise zia trel##usa tblending##usa tseparate##usa trel##c.zrfs tblending##c.zrfs tseparate##c.zrfs
margins, at(zrfs=(-1 1) usa=0 trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=0 trel=0 tblending=1 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=0 trel=0 tblending=0 tseparate=1) atmean vsquish


/*================*/
/*2-way INTERACTIONS: COUNTRY X TREATMENTS*/
/*================*/

reg voting zedu zage zexpertise zia zrfs trel##usa tblending##usa tseparate##usa
margins, at(usa=(0 1) trel=(0 1) tblending=0 tseparate=0) atmean vsquish

reg voting zedu zage zexpertise zia zrfs trel##usa tblending##usa tseparate##usa
margins, at(usa=(0 1) trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(usa=(0 1) trel=0 tblending=0 tseparate=1) atmean vsquish

/*================*/
/*3-way INTERACTIONS*/
/*================*/

reg voting zedu zage zexpertise zia trel##usa##c.zrfs tblending##usa##c.zrfs tseparate##usa##c.zrfs
margins, at(zrfs=(-1 1) usa=(0 1) trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=(0 1) trel=0 tblending=1 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=(0 1) trel=0 tblending=0 tseparate=1) atmean vsquish

reg attitude zedu zage zexpertise zia trel##usa##c.zrfs tblending##usa##c.zrfs tseparate##usa##c.zrfs
margins, at(zrfs=(-1 1) usa=(0 1) trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=(0 1) trel=0 tblending=0 tseparate=1) atmean vsquish

reg integrity zedu zage zexpertise zia trel##usa##c.zrfs tblending##usa##c.zrfs tseparate##usa##c.zrfs
margins, at(zrfs=(-1 1) usa=(0 1) trel=0 tblending=0 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=(0 1) trel=0 tblending=1 tseparate=0) atmean vsquish
margins, at(zrfs=(-1 1) usa=(0 1) trel=0 tblending=0 tseparate=1) atmean vsquish

log close
